/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.serverlist;

import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.hooks.client.screen.ScreenHooks;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.creeperhost.minetogether.Constants;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.chat.gui.ChatScreen;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.gui.SettingsScreen;
import net.creeperhost.minetogether.lib.web.ApiClientResponse;
import net.creeperhost.minetogether.polylib.gui.IconButton;
import net.creeperhost.minetogether.serverlist.data.ListType;
import net.creeperhost.minetogether.serverlist.data.Server;
import net.creeperhost.minetogether.serverlist.gui.JoinMultiplayerScreenPublic;
import net.creeperhost.minetogether.serverlist.gui.ServerTypeScreen;
import net.creeperhost.minetogether.serverlist.web.GetServerListRequest;
import net.creeperhost.minetogether.util.ModPackInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MineTogetherServerList {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<Server> servers = new LinkedList<Server>();
    @Nullable
    private static ListType lastRequest;
    private static long lastRequestTime;
    private static boolean incorrectlyConfigured;

    public static void init() {
        ModPackInfo.waitForInfo(versionInfo -> {
            incorrectlyConfigured = versionInfo.curseID.isEmpty();
            if (incorrectlyConfigured) {
                Server server = new Server();
                server.name = "No project ID! Please fix the MineTogether config or ensure a version.json exists.";
                List<Server> list = servers;
                synchronized (list) {
                    servers.add(server);
                }
            }
        });
        ClientGuiEvent.INIT_POST.register(MineTogetherServerList::onScreenOpen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Server> updateServers(ListType type) {
        List<Server> list = servers;
        synchronized (list) {
            if (incorrectlyConfigured || lastRequest == type && lastRequestTime + 30000L < System.currentTimeMillis()) {
                return Collections.unmodifiableList(servers);
            }
            try {
                ApiClientResponse<GetServerListRequest.Response> resp = MineTogether.API.execute(new GetServerListRequest(type, MineTogetherChat.CHAT_AUTH.getHash()));
                servers.clear();
                servers.addAll(resp.apiResponse().servers);
            }
            catch (Throwable ex) {
                LOGGER.error("Failed to update server listings.", ex);
            }
            return Collections.unmodifiableList(servers);
        }
    }

    private static void onScreenOpen(Screen screen, ScreenAccess screenAccess) {
        if (!(screen instanceof JoinMultiplayerScreen)) {
            return;
        }
        JoinMultiplayerScreen mpScreen = (JoinMultiplayerScreen)screen;
        if (screen instanceof JoinMultiplayerScreenPublic) {
            return;
        }
        Button serverListButton = new Button(screen.f_96543_ - 105, 5, 100, 20, (Component)new TranslatableComponent("minetogether:screen.multiplayer.serverlist"), e -> Minecraft.m_91087_().m_91152_((Screen)new ServerTypeScreen((Screen)mpScreen)));
        serverListButton.f_93623_ = !MineTogetherChat.isNewUser();
        ScreenHooks.addRenderableWidget((Screen)mpScreen, (AbstractWidget)serverListButton);
        boolean chatEnabled = Config.instance().chatEnabled;
        ScreenHooks.addRenderableWidget((Screen)screen, (AbstractWidget)new IconButton(screen.f_96543_ - 125, 5, chatEnabled ? 1 : 3, Constants.WIDGETS_SHEET, e -> Minecraft.m_91087_().m_91152_(chatEnabled ? new ChatScreen(screen) : new SettingsScreen(screen))));
    }

    static {
        lastRequestTime = 0L;
        incorrectlyConfigured = true;
    }
}

